import pygame


class HUD:
    def __init__(self, screen):
        self.screen = screen
        self.font = pygame.font.SysFont("arial", 20, bold=True)

    def draw_healthbar(self, player):
        BAR_WIDTH = 200
        BAR_HEIGHT = 20
        x = 20
        y = self.screen.get_height() - 40

        ratio = player.health / player.max_health
        ratio = max(0, min(1, ratio))

        # Hintergrund
        pygame.draw.rect(
            self.screen, (60, 60, 60),
            (x - 2, y - 2, BAR_WIDTH + 4, BAR_HEIGHT + 4)
        )

        # Farbe je nach HP
        if ratio > 0.5:
            color = (0, 200, 0)
        elif ratio > 0.25:
            color = (200, 200, 0)
        else:
            color = (200, 0, 0)

        pygame.draw.rect(
            self.screen, color,
            (x, y, BAR_WIDTH * ratio, BAR_HEIGHT)
        )

        text = self.font.render(f"HP: {int(player.health)}", True, (255, 255, 255))
        self.screen.blit(text, (x + 5, y - 22))

    def draw_score(self, score, kills):
        score_text = self.font.render(f"Score: {score}", True, (255, 255, 255))
        kill_text = self.font.render(f"Kills: {kills}", True, (255, 255, 255))

        self.screen.blit(score_text, (20, 20))
        self.screen.blit(kill_text, (20, 45))
